/*
 * LayoutAppender.cpp
 *
 * Copyright 2000, LifeLine Networks BV (www.lifeline.nl). All rights reserved.
 * Copyright 2000, Bastiaan Bakker. All rights reserved.
 *
 * See the COPYING file for the terms of usage and distribution.
 */
#ifdef _MSC_VER
#   pragma warning( disable : 4702 ) //unreachable code in STL for VC71
#endif

#include "PortabilityImpl.hh"
#include <log4cpp/LayoutAppender.hh>

LOG4CPP_NS_BEGIN

LayoutAppender::LayoutAppender(const std::string& name) :
AppenderSkeleton(name),
_layout(new DefaultLayoutType()) {
}

LayoutAppender::~LayoutAppender() {
    delete _layout;
}

bool LayoutAppender::requiresLayout() const {
    return true;
}

void LayoutAppender::setLayout(Layout* layout) {
    if (layout != _layout) {
        Layout *oldLayout = _layout;
        _layout = (layout == NULL) ? new DefaultLayoutType() : layout;
        delete oldLayout;
    }
}

Layout& LayoutAppender::_getLayout() {
    return *_layout;
}
LOG4CPP_NS_END

